"use client";
import React, { useEffect } from "react";
import studentProfile from "../../../../../public/assets/dashboard/profile.png";
import certificate1 from "../../../../../public/assets/dashboard/certification/image1.png";
import certificate2 from "../../../../../public/assets/dashboard/certification/image2.png";
import certificate3 from "../../../../../public/assets/dashboard/certification/image3.png";
import certificate4 from "../../../../../public/assets/dashboard/certification/image4.png";
import certificateErrorImg from "../../../../../public/assets/CERTIFICATE-2nd-variation.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faDownload } from "@fortawesome/free-solid-svg-icons";
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import { faArrowRightLong } from "@fortawesome/free-solid-svg-icons";
import { faArrowLeftLong } from "@fortawesome/free-solid-svg-icons";
import { faFileImport } from "@fortawesome/free-solid-svg-icons";
import { Pie } from "react-chartjs-2";
import {
  faGraduationCap,
  faEllipsisVertical,
} from "@fortawesome/free-solid-svg-icons";
import { Chart as ChartJS, ArcElement, Tooltip, Legend } from "chart.js";
import Link from "next/link";
import Header from "../header/header";
import { useSelector, useDispatch } from "react-redux";
// import { fetchCourseProgress } from "@/newStore/features/courseProgresSlice";
import { fetchEnrolledCourses } from "@/newStore/features/enrolledCoursesSlice";
import LoaderCircle from "../../loaderCircle/loaderCircle";
import { useGetCertificatesQuery } from "@/services/Api";
import toast from "react-hot-toast";
ChartJS.register(ArcElement, Tooltip, Legend);

const Certifications = () => {
  const dispatch = useDispatch();
  const courseProgress = useSelector((state) => state.courseProgress);
  const enrolledCourses = useSelector(
    (state) => state.enrolledCourses.enrolledCourses
  );
  const enrolledCoursesLoader = useSelector(
    (state) => state.enrolledCourses.isLoading
  );
  const { data, isLoading } = useGetCertificatesQuery();
  const certificates = data?.certificates;
  useEffect(() => {
    // dispatch(fetchCourseProgress(1));
    dispatch(fetchEnrolledCourses());
  }, []);

  const settings = {
    infinite: false,
    speed: 500,
    arrows: true,
    slidesToShow: 4,
    slidesToScroll: 1,
    prevArrow: <FontAwesomeIcon icon={faArrowLeftLong} />,
    nextArrow: <FontAwesomeIcon icon={faArrowRightLong} />,
    responsive: [
      {
        breakpoint: 1440,
        settings: {
          slidesToShow: 3,
        },
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 2,
        },
      },
      {
        breakpoint: 539,
        settings: {
          slidesToShow: 1,
        },
      },
    ],
  };
  const certImg = certificates?.license || certificateErrorImg;
  const downloadImage = async (url, filename = "certificate.png") => {
    console.log("download url", url);
    try {
      const res = await fetch(url);
      const blob = await res.blob();
      const link = document.createElement("a");
      link.href = window.URL.createObjectURL(blob);
      link.download = filename;
      link.click();
      window.URL.revokeObjectURL(link.href);
    } catch (error) {
      console.error("Download failed:", error);
    }
  };
  return (
    <div className="md:px-[28px] px-3 pb-8 min-h-screen">
      <Header title="Certifications" />
      {enrolledCourses?.courses?.length > 0 && (
        <div className="bg-white mt-6 rounded-2xl w-full max-h-full p-6 mb-4">
          <div className="mb-4">
            <p className="text-[22px] font-bold">Courses Progress</p>
          </div>
          {enrolledCoursesLoader ? (
            <div className="pr-2 h-[280px] flex justify-center items-center">
              <LoaderCircle />
            </div>
          ) : (
            <div>
              {enrolledCourses === null ? (
                <div className="flex justify-center items-center min-h-[377px] min-w-full">
                  <LoaderCircle />
                </div>
              ) : enrolledCourses?.courses?.length > 0 ? (
                <Slider
                  slideCount={enrolledCourses?.courses?.length}
                  {...settings}
                  className="course-progress-slider"
                >
                  {enrolledCourses?.courses?.map((course, index) => (
                    <div key={index}>
                      {/* w-[220px] sm:w-[250px] md:w-[300px] */}
                      <div className=" border border-[#c7c7c7] rounded-xl overflow-hidden">
                        <div className="flex justify-between mb-3 relative">
                          <Image
                            src={course?.media[0]?.url || certificate1}
                            alt="student-profile"
                            className="h-[220px] w-full object-cover"
                          />
                          <p
                            className={
                              course?.status === "completed"
                                ? "border-[#0EAD71] text-[#0EAD71] text-[14px] font-medium absolute top-2 right-2 border rounded-full px-2 py-1 bg-white "
                                : "border-[#00CED1] text-[#00CED1] text-[14px] font-medium absolute top-2 right-2 border rounded-full px-2 py-1 bg-white"
                            }
                            style={{
                              color:
                                course?.status === "completed"
                                  ? "#0EAD71"
                                  : "#00CED1",
                            }}
                          >
                            {course?.status === "completed"
                              ? "Done"
                              : "Ongoing"}
                          </p>
                        </div>
                        <div className="p-4">
                          <h3 className="text-[18px] font-bold -mt-2 mb-2">
                            {course?.title}
                          </h3>
                          <div className="flex items-center gap-2 mb-3">
                            <div className="w-full h-[6px] bg-[#D9D9D9] rounded-3xl">
                              <div
                                className="bg-golden rounded-3xl h-[6px]"
                                style={{
                                  width: `${course?.progress_percentage}%`,
                                }}
                              ></div>
                            </div>
                            <span>{`${course?.progress_percentage}%`}</span>
                          </div>

                          <div className="flex justify-between">
                            <div className="flex items-center gap-2">
                              <Image
                                src={
                                  course?.user?.profile_photo_path ||
                                  studentProfile
                                }
                                alt="student-profile"
                                className="w-[30px] max-h-[30px] object-cover"
                              />
                              <span className="text-[12px]">
                                {course?.user?.name}
                              </span>
                            </div>
                            {/* <div className="flex items-center gap-2">
                              <FontAwesomeIcon icon={faFileImport} />
                            </div> */}
                            <Link
                              href={`/courses/${course.id}`}
                              className=" bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
                            >
                              Watch
                            </Link>
                          </div>
                        </div>
                      </div>
                    </div>
                  ))}
                </Slider>
              ) : (
                <div className="flex justify-center items-center min-h-[377px] min-w-full">
                  No Courses Available
                </div>
              )}
            </div>
          )}
        </div>
      )}
      <div className="bg-white rounded-2xl w-full max-h-full p-6">
        <div className="flex justify-between items-center mb-8">
          <p className="text-[20px] font-bold">Here Are Your Certifications</p>
          <Link href="certifications/all" className="text-[18px] font-bold">
            See all
          </Link>
        </div>
        <div className="mt-4 grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] xl:gap-x-10 gap-x-4 gap-y-4">
          {isLoading ? (
            <div className="pr-2 h-[280px] flex justify-center items-center">
              <LoaderCircle />
            </div>
          ) : certificates?.length > 0 ? (
            certificates?.map((certificate, index) => (
              <div className="w-full" key={index}>
                <img
                  src={certificate?.license || certificateErrorImg}
                  alt="certificate"
                  className="w-full rounded-lg"
                  width={400}
                  height={300}
                  onError={(e) => {
                    e.currentTarget.src = certificateErrorImg.src;
                  }}
                />
                <div className="flex justify-between mt-3">
                  <p className="text-[#363636] font-bold">
                    {certificate?.course_name}
                  </p>
                  <button
                    className="text-blue-800"
                    onClick={() =>
                      downloadImage(
                        certificate?.license,
                        `${certificate?.course_name || "certificate"}.png`
                      )
                    }
                  >
                    <FontAwesomeIcon icon={faDownload} />
                  </button>
                </div>
              </div>
            ))
          ) : (
            <div className="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400 w-full lg:col-span-4 md:col-span-3 sm:col-span-2 col-span-1">
              No certificate found
            </div>
          )}
        </div>
      </div>
    </div>
  );
};

export default Certifications;
